<?php
//VERSION 0


$DOCUMENT_ROOT="/var/www/html";//A virer ce truc ou bien???
if($DOCUMENT_ROOT[strlen($DOCUMENT_ROOT)-1]=="/"){
	$DOCUMENT_ROOT=substr($DOCUMENT_ROOT,0,-1);
}
require_once($DOCUMENT_ROOT."/page/include/TCPDF-master/examples/lang/eng.php");
require_once($DOCUMENT_ROOT."/page/include/TCPDF-master/tcpdf.php");
require_once($DOCUMENT_ROOT."/page/include/TCPDF-master/tcpdf_parser.php");
function AddPaiement($idEcole,$idClient,$idStaff,$idFormule,$idProduit,$idLocation,$type,$montant,$comment,$host){
	if($montant!=""){
		$laDate=date("Y-m-d H:i:s");
//		$ret=AddPaiementBD($idEcole,$idFormule,$idProduit,$idLocation,$idStaff,$type,$montant,$comment,$laDate);
		$ret=AddPaiementBD($idEcole,$idFormule,$idProduit,$idLocation,-1,$idStaff,$type,$montant,$comment,$laDate);
		if($idFormule!=-1){
			$paramDTF['motif']="Ajout paiement";
			RecalculeMontantRestantDuFormule($idEcole,$idClient,$idFormule,$host,$paramDTF);
		}
		elseif($idLocation!=-1){
			$paramDTF['motif']="Ajout paiement";
			RecalculeMontantRestantDuLocation($idEcole,$idClient,$idLocation,$paramDTF);
		}
		elseif($idProduit!=-1){
			$paramDTF['motif']="Ajout paiement";
			RecalculeMontantRestantDuProduit($idEcole,$idProduit,$paramDTF);
		}
	}
}
function HashThis($that){//Et pas $this en parametre, ca plante le script...
	return hash("sha256",$that);
}
function AddPaiementFactureGroupee($idEcole,$idClient,$idStaff,$idFactureGroupee,$type,$montant,$comment,$isDevis){
	if($montant!=""){
		$laDate=date("Y-m-d H:i:s");
//		$ret=AddPaiementFactureGroupeeBD($idEcole,$idFactureGroupee,$idStaff,$type,$montant,$comment,$laDate);
		$ret=AddPaiementBD($idEcole,-1,-1,-1,$idFactureGroupee,$idStaff,$type,$montant,$comment,$laDate);
		$paramDTF['motif']="Ajout paiement";
		UpdateRestantDuFactureGroupee($idEcole,$idFactureGroupee,$isDevis,$paramDTF);
	}
}
function ModifEnregistrementPaiement($idEcole,$idClient,$idFormule,$idPaiement,$commentaire,$host){
	$champs=GetChampsEtTaille("paiement");
	$params=GetEnregistrementInfo("paiement",$idPaiement);
	$cpt=0;
	$newParam=Array();
	foreach($champs as $champ){
		if($champ[0]=="commentaire"){
			$newParam[$cpt]=$commentaire;
		}
		else{
			$newParam[$cpt]=$params[$cpt];
		}
		$cpt++;
	}
	$modif=ModifEnregistrement("paiement",$idPaiement,$newParam,$host);
	return $modif;
}
function ModifEnregistrementPaiementFactureGroupee($idEcole,$idClient,$idFactureGroupee,$idPaiement,$commentaire){
	$champs=GetChampsEtTaille("paiement");
	$params=GetEnregistrementInfo("paiement",$idPaiement);
	$cpt=0;
	$newParam=Array();
	foreach($champs as $champ){
		if($champ[0]=="commentaire"){
			$newParam[$cpt]=$commentaire;
		}
		else{
			$newParam[$cpt]=$params[$cpt];
		}
		$cpt++;
	}
	$modif=ModifEnregistrement("paiement",$idPaiement,$newParam);
	return $modif;
}
function GetPaiement($idEcole,$idFormule,$dateCreationFormule){
//Pour les vielles formules, il faut ajouter les paiements qui sonts dans "formule" en plus des enregistrements de "paiements"
	$newWay=NeedNewWay($dateCreationFormule);
	$ret=Array();		
	$cpt=0;
	if($newWay==0){
		$paiements=GetPaimentOldWayBD($idEcole,$idFormule);
		$ret[$cpt]['idPaiement']=-1;
		if($paiements['paye_cb']!=0){
			$ret[$cpt]['montant']=$paiements['paye_cb'];
			$ret[$cpt]['date']=RenverseDateDifferentEncore($paiements['date_paye_cb']);
			$ret[$cpt]['type']="cb";
			$ret[$cpt]['commentaire']=$paiements['commentaire'];
			$ret[$cpt]['idPaiement']=-1;
			$cpt++;
		}
		if($paiements['paye_cheque_vac']!=0){
			$ret[$cpt]['montant']=$paiements['paye_cheque_vac'];
			$ret[$cpt]['date']=RenverseDateDifferentEncore($paiements['date_paye_cheque_vac']);
			$ret[$cpt]['type']="chèque vacances";
			$ret[$cpt]['commentaire']=$paiements['commentaire'];
			$ret[$cpt]['idPaiement']=-1;
			$cpt++;
		}
		if($paiements['paye_cheque']!=0){
			$ret[$cpt]['montant']=$paiements['paye_cheque'];
			$ret[$cpt]['date']=RenverseDateDifferentEncore($paiements['date_paye_cheque']);
			$ret[$cpt]['type']="chèque";
			$ret[$cpt]['commentaire']=$paiements['commentaire'];
			$ret[$cpt]['idPaiement']=-1;
			$cpt++;
		}
		if($paiements['paye_cash']!=0){
			$ret[$cpt]['montant']=$paiements['paye_cash'];
			$ret[$cpt]['date']=RenverseDateDifferentEncore($paiements['date_paye_cash']);
			$ret[$cpt]['type']="espèces";
			$ret[$cpt]['commentaire']=$paiements['commentaire'];
			$ret[$cpt]['idPaiement']=-1;
			$cpt++;
		}
		if($paiements['paye_virement']!=0){
			$ret[$cpt]['montant']=$paiements['paye_virement'];
			$ret[$cpt]['date']=RenverseDateDifferentEncore($paiements['date_paye_virement']);
			$ret[$cpt]['type']="virement";
			$ret[$cpt]['commentaire']=$paiements['commentaire'];
			$ret[$cpt]['idPaiement']=-1;
			$cpt++;
		}
		if($paiements['paye_amex']!=0){
			$ret[$cpt]['montant']=$paiements['paye_amex'];
			$ret[$cpt]['date']=RenverseDateDifferentEncore($paiements['date_paye_amex']);
			$ret[$cpt]['type']="amex";
			$ret[$cpt]['commentaire']=$paiements['commentaire'];
			$ret[$cpt]['idPaiement']=-1;
			$cpt++;
		}
		if($paiements['paye_paypal']!=0){
			$ret[$cpt]['montant']=$paiements['paye_paypal'];
			$ret[$cpt]['date']=RenverseDateDifferentEncore($paiements['date_paye_paypal']);
			$ret[$cpt]['type']="paypal";
			$ret[$cpt]['commentaire']=$paiements['commentaire'];
			$ret[$cpt]['idPaiement']=-1;
			$cpt++;
		}
		if($paiements['paye_bon_cadeau']!=0){
			$ret[$cpt]['montant']=$paiements['paye_bon_cadeau'];
			$ret[$cpt]['date']=RenverseDateDifferentEncore($paiements['date_paye_bon_cadeau']);
			$ret[$cpt]['type']="bon cadeau";
			$ret[$cpt]['commentaire']=$paiements['commentaire'];
			$ret[$cpt]['idPaiement']=-1;
			$cpt++;
		}
	}
	$retTemp=GetPaimentNewWayBD($idEcole,$idFormule);
	foreach($retTemp as $rt){
		$ret[$cpt]=$rt;
		$ret[$cpt]['type']=GetTypeDisplay($idEcole,$rt['type']);
		$cpt++;
	}
	return $ret;
}
function NeedNewWay($dateCreationFormule){
	$ret=0;
	$dateLimiteChangementWay="2014-04-16";
	$dateFormule=substr($dateCreationFormule,0,10);
	if($dateFormule>=$dateLimiteChangementWay){
		$ret=1;//Nouvelle methode
	}
//	return 0;
	return $ret;
}
function AjustePrixApresRemise($prixFormule,$discount){
	//Les 2 suivants a sortir
//	$ret['montant']=$prixFormule;
//	$ret['display']="";
	$ret['montantApresRemise']=$prixFormule;
	$ret['displayMontantDeLaRemise']="";
	$ret['montantDeLaRemise']=0;
	if($discount!=0){
		if(strpos($discount,"e")>0){
			$remiseMontant=substr($discount,0,strpos($discount,"e"));
			$prixFormule=$prixFormule-$remiseMontant;
//			$ret['montant']=round($prixFormule*100)/100;//pour avoir que 2 decimales
			$ret['montantApresRemise']=round($prixFormule*100)/100;//pour avoir que 2 decimales
//			$ret['display']=$remiseMontant."€";
			$ret['displayMontantDeLaRemise']=$remiseMontant."€";
			$ret['montantDeLaRemise']=$remiseMontant;
		}
		else{//On stocke 10 si on avait saisi 10%
			$ret['montantDeLaRemise']=$discount*$prixFormule/100;
			$prixFormule=$prixFormule-$ret['montantDeLaRemise'];
//			$ret['montant']=round($prixFormule*100)/100;//pour avoir que 2 decimales
			$ret['montantApresRemise']=round($prixFormule*100)/100;//pour avoir que 2 decimales
//			$ret['display']=$discount."%";
			$ret['displayMontantDeLaRemise']=$discount."%";
		}
	}
	return $ret;
}
function AddupDTFParameters($paramDTF,$tauxTVA,$nom,$descriptifProduit,$prixTotal,$prixTotalApresRemise,$montantDeLaRemise,$displayRemiseSimple,$paiements,$nouveauRestantDu,$typeArticle,$listingMoniteur){
	//Les 3 suivants tiennent en compte la remise
	$eclateTVAIncluantRemise=EclateTVA($tauxTVA,$prixTotalApresRemise);
	$paramDTF['totalHT']=$eclateTVAIncluantRemise['montantHT'];
	$paramDTF['totalTVA']=$eclateTVAIncluantRemise['montantTVA'];
	$paramDTF['totalTTC']=$eclateTVAIncluantRemise['montantTTC'];

	$paramDTF['ArticleMontantHT']=$eclateTVAIncluantRemise['montantHT'];
	$paramDTF['ArticleMontantTVA']=$eclateTVAIncluantRemise['montantTVA'];
	$paramDTF['ArticleMontantTTC']=$eclateTVAIncluantRemise['montantTTC'];
	$paramDTF['articleTauxTVA']=$eclateTVAIncluantRemise['tvaRetenue'];

	$paramDTF['totalMontantDeLaRemise']=$montantDeLaRemise;
//	$paramDTF['articleDescriptif']=$typeArticle." ".strtolower($nom);
	$paramDTF['articleDescriptif']=strtolower($nom);
	$paramDTF['articleDescriptifExtra']=$descriptifProduit;
//Carole n'en veut pas là en fait...
//	$paramDTF['listingMoniteurExtra']=$listingMoniteur;
	$paramDTF['listingMoniteurExtra']="";


	$paramDTF['articleRemiseDisplay']=$displayRemiseSimple;
	$paramDTF['articleRemiseMontant']=$montantDeLaRemise;

	$paramDTF['reglementType']="";
	$paramDTF['reglementMontant']="";
	$cpt=0;
	foreach($paiements as $paiement){
		if($cpt!=0){
			$paramDTF['reglementType'].=";";
			$paramDTF['reglementMontant'].=";";
		}
		$paramDTF['reglementType'].=$paiement['type'];
		$paramDTF['reglementMontant'].=$paiement['montant'];
		$cpt++;
	}
	$paramDTF['restantDu']=$nouveauRestantDu;
	return $paramDTF;
}
function AddupDTFParametersFactureGroupee($paramDTF,$montant){
	$paramDTF['formules']=$montant['formules'];
	$paramDTF['locations']=$montant['locations'];
	$paramDTF['produits']=$montant['produits'];

	$paramDTF['articleTauxTVA']=RemoveLastUnnecessaryLastCharIfNecessary($montant['articleTauxTVAForDTF']);
	$paramDTF['articleDescriptif']=RemoveLastUnnecessaryLastCharIfNecessary($montant['articleDescriptifForDTF']);
	$paramDTF['articleDescriptifExtra']=RemoveLastUnnecessaryLastCharIfNecessary($montant['articleDescriptifExtraForDTF']);
	$paramDTF['listingMoniteurExtra']=RemoveLastUnnecessaryLastCharIfNecessary($montant['listingMoniteurExtraForDTF']);
	$paramDTF['reglementType']=RemoveLastUnnecessaryLastCharIfNecessary($montant['paiementsTypeForDTF']);
	$paramDTF['reglementMontant']=RemoveLastUnnecessaryLastCharIfNecessary($montant['paiementsMontantForDTF']);

	$paramDTF['totalHT']=$montant['totalHTForDTF'];
	$paramDTF['totalTVA']=$montant['totalTVAForDTF'];
	$paramDTF['totalTTC']=$montant['totalTTCForDTF'];
	$paramDTF['totalMontantDeLaRemise']=$montant['totalMontantDeLaRemiseDTF'];
	$paramDTF['remiseFactureGroupeeMontant']=$montant['remiseFactureGroupeeMontantDTF'];
	$paramDTF['remiseFactureGroupeeDisplay']=$montant['remiseFactureGroupeeDisplayDTF'];
	$paramDTF['ArticleMontantHT']=RemoveLastUnnecessaryLastCharIfNecessary($montant['ArticleMontantHTForDTF']);
	$paramDTF['ArticleMontantTVA']=RemoveLastUnnecessaryLastCharIfNecessary($montant['ArticleMontantTVAForDTF']);
	$paramDTF['ArticleMontantTTC']=RemoveLastUnnecessaryLastCharIfNecessary($montant['ArticleMontantTTCForDTF']);
	$paramDTF['articleRemiseDisplay']=RemoveLastUnnecessaryLastCharIfNecessary($montant['articleRemiseDisplayForDTF']);
	$paramDTF['articleRemiseMontant']=RemoveLastUnnecessaryLastCharIfNecessary($montant['articleRemiseMontantForDTF']);
	$paramDTF['restantDu']=$montant['restantDu'];
	return $paramDTF;
}
function EclateTVA($tauxTVA,$prixTotal){
	$ret['tvaRetenue']=$tauxTVA;
	if($ret['tvaRetenue']==-1){//Pas de TVA
		$ret['montantHT']=$prixTotal;
		$ret['montantTVA']=-1;
		$ret['montantTTC']=-1;
	}
	else{
		$temp=$prixTotal/(1+($ret['tvaRetenue']/100));
		$ret['montantHT']=round($temp*100)/100;
		$ret['montantTVA']=round(($prixTotal-$ret['montantHT'])*100)/100;
		$ret['montantTTC']=$prixTotal;
	}
	return $ret;
}
function AddDTF($idEcole,$typeArticle,$idArticle,$isDevis,$paramOptionnels){
	$laDate=date("Y-m-d H:i:s");
	$anneeMois=date("Ym");
	$nouveauNumero=CreateNumeroVersion($idEcole,$typeArticle,$idArticle,$isDevis,$anneeMois);
	$lienVersAncienDTFFactureGroupee=isset($paramOptionnels['lienVersAncienDTFFactureGroupee'])?$paramOptionnels['lienVersAncienDTFFactureGroupee']:-1;
	$nouvelId=AddDTFBD($idEcole,$typeArticle,$idArticle,$nouveauNumero['numero'],$nouveauNumero['version'],$laDate, $lienVersAncienDTFFactureGroupee,$paramOptionnels);
	AddPdfDTF($idEcole,$nouvelId);
	//Invalidation des autres enregistrements
	if($isDevis==1){//si on est en devis
		if($nouveauNumero['idDTFaInvalider']!=-1){//Si un enregistrement precedant a été trouve, on l'invalide
			InvalideDTF($idEcole,$nouveauNumero['idDTFaInvalider'],$laDate,$paramOptionnels['motif'],$nouvelId);
		}
	}
	elseif($isDevis==-1){//si on est en facture
		if($nouveauNumero['idDTFaInvalider']!=-1){//Si un enregistrement precedant a été trouve, on l'invalide
			InvalideDTF($idEcole,$nouveauNumero['idDTFaInvalider'],$laDate,$paramOptionnels['motif'],$nouvelId);
		}
		else{//Sinon rechercher si on a devis associé.
			$dtfInfos=GetDTFWithMaxVersionNb($idEcole,$typeArticle,$idArticle,"D");
			if($dtfInfos['idDTF']!="" and $dtfInfos['idDTF']!=$nouvelId and $dtfInfos['invalideDate']==""){//Si on a un devis associé, ca veut dire qu'on vient juste de valider un devis en facture
			//Il faut donc invalider ce dernier devis.
				InvalideDTF($idEcole,$dtfInfos['idDTF'],$laDate,$paramOptionnels['motif'],$nouvelId);
			}
		}
	}
	if($typeArticle=="facture_groupee"){//Si on est en facture goupee
		//on recupére l'ensemble des articles liées
		//On invalide les ticket si ca n'a pas dejà été fait.
		//Comme ca on couvre l'ajout d'un devis au devis facture groupée, la validation du devis fact groupée, et aussi l'ajout d'un devis article dans la fact groupée, dejà validée.
		foreach($paramOptionnels['formules'] as $formule){
			ChercheCourantEtInvalideDTF($idEcole,"formule",$formule['idFormule'],$laDate,$paramOptionnels['motif'],$nouvelId);
		}
		foreach($paramOptionnels['locations'] as $location){
			ChercheCourantEtInvalideDTF($idEcole,"location",$location['idLocation'],$laDate,$paramOptionnels['motif'],$nouvelId);
		}
		foreach($paramOptionnels['produits'] as $produit){
			ChercheCourantEtInvalideDTF($idEcole,"produit",$produit['idProduit'],$laDate,$paramOptionnels['motif'],$nouvelId);
		}
	}
	return 1;
}
function CreateNumeroVersion($idEcole,$typeArticle,$idArticle,$isDevis,$anneeMois){
	$pref=$isDevis==1?"D":"F";
	$dtfInfos=GetDTFWithMaxVersionNb($idEcole,$typeArticle,$idArticle,$pref);//Recupérer l'enr precedant du meme article
	$idDtfPrecedant=$dtfInfos['idDTF'];
	$ret=Array();
	if($idDtfPrecedant!=""){//on a trouvee un enr correspondant à cet article
		$ret['numero']=$dtfInfos['numero'];
		$ret['version']=$dtfInfos['version']+1;
		$ret['idDTFaInvalider']=$idDtfPrecedant;
	}
	if($idDtfPrecedant==""){//Si pas encore d'entree pour cet article, on va chercher le numero max de la base
		$numerotemp=GetDTFMaxNumber($idEcole,$isDevis);
		if($numerotemp=="" or substr($numerotemp,1,6)!=$anneeMois){//Si aucun enr en base ou l'enr est du mois precedant
			$ret['numero']=$pref.$anneeMois."00001";
		}
		else{
			$numerotemp1=substr($numerotemp,7);//Pour enlever le prefixe D ou F, et aussi le aaaann, pour pouvoir faire le +1
			$numerotemp1++;
			$prefs="0000";
			$prefs=$numerotemp1>=10?"000":$prefs;
			$prefs=$numerotemp1>=100?"00":$prefs;
			$prefs=$numerotemp1>=1000?"0":$prefs;
			$prefs=$numerotemp1>=10000?"":$prefs;
			$ret['numero']=substr($numerotemp,0,7).$prefs.$numerotemp1;
		}
		$ret['version']=1;
		$ret['idDTFaInvalider']=-1;
	}
	return $ret;
}
function GetDTFWithMaxVersionNb($idEcole,$typeArticle,$idArticle,$pref){
	$dtfInfos=GetDTFWithMaxVersionNbBD($idEcole,$typeArticle,$idArticle,$pref);
	return $dtfInfos;
}
function InvalideDTF($idEcole,$idDTFaInvalider,$date,$motif,$nouvelId){
	InvalideDTFBD($idEcole,$idDTFaInvalider,$date,$motif,$nouvelId);
}
function ChercheCourantEtInvalideDTF($idEcole,$table,$id,$laDate,$motif,$nouvelId){
	$dtfInfos=GetCurrentDTF($idEcole,$table,$id);
	if($dtfInfos['idDTF']!=""){
		InvalideDTF($idEcole,$dtfInfos['idDTF'],$laDate,$motif,$nouvelId);
	}
}
function GetCurrentDTF($idEcole,$typeArticle,$idArticle){
	return GetCurrentDTFBD($idEcole,$typeArticle,$idArticle);
}
function GetTvaRetenue($tvaPrincipal,$tvaSpecifique){
	if($tvaPrincipal==-1){//TVA non applicable
		if($tvaSpecifique==-1){
			$tvaRetenue=-1;
		}
		else{
			$tvaRetenue=$tvaSpecifique;
		}
	}
	else{
		$tvaRetenue=$tvaSpecifique!=-1?$tvaSpecifique:$tvaPrincipal;
	}
	return $tvaRetenue;
}
function GetPaiementFactureGroupee($idEcole,$idFactureGroupee){
	$ret=Array();		
	$cpt=0;
	$retTemp=GetPaimentNewWayFactureGroupeeBD($idEcole,$idFactureGroupee);
	foreach($retTemp as $rt){
		$ret[$cpt]=$rt;
		$ret[$cpt]['type']=GetTypeDisplay($idEcole,$rt['type']);
		$cpt++;
	}
	return $ret;
}
function GetClientInfoForPdf($idEcole,$paramDTF){
	if(isset($paramDTF['idFormule']) and $paramDTF['idFormule']!=-1){
		return GetClientInfoForPdfBD($idEcole,"formule",$paramDTF['idFormule']);
	}
	if(isset($paramDTF['idLocation']) and $paramDTF['idLocation']!=-1){
		return GetClientInfoForPdfBD($idEcole,"location",$paramDTF['idLocation']);
	}
	if(isset($paramDTF['idProduit']) and $paramDTF['idProduit']!=-1){
		return GetClientInfoForPdfBD($idEcole,"produit",$paramDTF['idProduit']);
	}
	if(isset($paramDTF['idFactureGroupee']) and $paramDTF['idFactureGroupee']!=-1){
		return GetClientInfoForPdfBD($idEcole,"facture_groupee",$paramDTF['idFactureGroupee']);
	}
}
function GetAllDevisTicketsFactures($idEcole,$annee){
	return GetAllDevisTicketsFacturesBD($idEcole,$annee);
}

// hash: 1dd35b4670fe30f521cdf5e3eea1d1e2ad0f56accc44a9b61a4ede4badc06c69
?>
